/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.api.client.CTMTexture;
import team.chisel.ctm.api.client.Renderable;
import team.chisel.ctm.api.client.TextureContext;
import team.chisel.ctm.client.model.CTMModelInfo;
import team.chisel.ctm.client.model.TextureContextMap;
import team.chisel.ctm.client.util.RenderUtil;

public class CTMBakedModel
extends ForwardingBakedModel {
    private static final Cache<BlockMeshCacheKey, Mesh> BLOCK_MESH_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build();
    private static final Cache<class_1087, Mesh> ITEM_MESH_CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    protected static final ThreadLocal<ObjectContainer> CONTAINERS = ThreadLocal.withInitial(ObjectContainer::new);
    @NotNull
    protected CTMModelInfo modelInfo;
    protected class_1058 sprite;

    public CTMBakedModel(@NotNull class_1087 parent, @NotNull CTMModelInfo modelInfo) {
        this.wrapped = Objects.requireNonNull(parent, "parent is marked non-null but is null");
        this.modelInfo = Objects.requireNonNull(modelInfo, "modelInfo is marked non-null but is null");
        this.sprite = this.initSprite();
    }

    public static void invalidateCaches() {
        BLOCK_MESH_CACHE.invalidateAll();
        ITEM_MESH_CACHE.invalidateAll();
    }

    @NotNull
    public class_1087 getParent() {
        return this.wrapped;
    }

    @NotNull
    public CTMModelInfo getModelInfo() {
        return this.modelInfo;
    }

    protected class_1058 initSprite() {
        CTMTexture<?> texture = this.getModelInfo().getTexture(this.getParent().method_4711().method_4598());
        if (texture != null) {
            return texture.getParticle();
        }
        return null;
    }

    public class_1058 method_4711() {
        if (this.sprite != null) {
            return this.sprite;
        }
        return super.method_4711();
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.meshConsumer().accept(this.getBlockMesh(state, blockView, pos, randomSupplier));
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        context.meshConsumer().accept(this.getItemMesh(stack, randomSupplier));
    }

    public Mesh getBlockMesh(class_2680 state, class_1920 blockView, class_2338 pos, Supplier<class_5819> randomSupplier) {
        ObjectContainer container = CONTAINERS.get();
        class_1087 parent = this.getParent();
        CTMModelInfo modelInfo = this.getModelInfo();
        TextureContextMap contextMap = container.contextMap;
        contextMap.fill(modelInfo.getTextures(), state, blockView, pos);
        Mesh mesh = null;
        try {
            mesh = (Mesh)BLOCK_MESH_CACHE.get((Object)new BlockMeshCacheKey(parent, state, contextMap.toDataArray()), () -> this.createMesh(parent, modelInfo, contextMap, state, randomSupplier, container.meshBuilder));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error getting CTM block mesh", e);
        }
        finally {
            contextMap.reset();
        }
        return mesh;
    }

    public Mesh getItemMesh(class_1799 itemStack, Supplier<class_5819> randomSupplier) {
        Mesh mesh = null;
        try {
            mesh = (Mesh)ITEM_MESH_CACHE.get((Object)this, () -> {
                class_1792 item = itemStack.method_7909();
                class_2248 block = null;
                if (item instanceof class_1747) {
                    block = ((class_1747)item).method_7711();
                }
                return this.createMesh(this.getParent(), this.getModelInfo(), null, block == null ? null : block.method_9564(), randomSupplier, CTMBakedModel.CONTAINERS.get().meshBuilder);
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error getting CTM item mesh", e);
        }
        return mesh;
    }

    protected Mesh createMesh(class_1087 parent, CTMModelInfo modelInfo, @Nullable TextureContextMap contextMap, @Nullable class_2680 state, Supplier<class_5819> randomSupplier, MeshBuilder meshBuilder) {
        QuadEmitter emitter = meshBuilder.getEmitter();
        for (class_2350 cullFace : RenderUtil.CULL_FACES) {
            List parentQuads = parent.method_4707(state, cullFace, randomSupplier.get());
            for (class_777 bakedQuad : parentQuads) {
                CTMTexture<?> texture;
                class_2960 spriteId = bakedQuad.method_35788().method_4598();
                int tintIndex = bakedQuad.method_3359();
                class_1058 overrideSprite = modelInfo.getOverrideSprite(tintIndex);
                if (overrideSprite != null) {
                    bakedQuad = RenderUtil.retextureBakedQuad(bakedQuad, overrideSprite);
                    spriteId = overrideSprite.method_4598();
                }
                if ((texture = modelInfo.getOverrideTexture(tintIndex, spriteId)) == null) {
                    texture = modelInfo.getTexture(spriteId);
                }
                boolean renderFallback = false;
                if (texture != null) {
                    TextureContext context = contextMap == null ? null : contextMap.getContext(texture);
                    Renderable renderable = texture.transformQuad(bakedQuad, cullFace, context);
                    if (renderable != null) {
                        renderable.render(emitter);
                    } else {
                        renderFallback = true;
                    }
                } else {
                    renderFallback = true;
                }
                if (!renderFallback) continue;
                emitter.fromVanilla(bakedQuad, null, cullFace);
                emitter.emit();
            }
        }
        return meshBuilder.build();
    }

    protected static class ObjectContainer {
        public TextureContextMap contextMap = new TextureContextMap();
        public MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();

        protected ObjectContainer() {
        }
    }

    private static class BlockMeshCacheKey {
        private final class_1087 parent;
        private final class_2680 blockState;
        private final long[] data;

        private BlockMeshCacheKey(class_1087 parent, class_2680 blockState, long[] data) {
            this.parent = parent;
            this.blockState = blockState;
            this.data = data;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BlockMeshCacheKey other = (BlockMeshCacheKey)obj;
            if (this.parent != other.parent) {
                return false;
            }
            if (this.blockState != other.blockState) {
                return false;
            }
            return Arrays.equals(this.data, other.data);
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.blockState, Arrays.hashCode(this.data));
        }
    }
}

